package nemosofts.voxradio.adapter;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.Filter;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RatingBar;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.nemosofts.theme.ColorUtils;
import androidx.nemosofts.view.RoundedImageView;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.gms.ads.nativead.MediaView;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.ironsource.mediationsdk.ISBannerSize;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.squareup.picasso.Picasso;
import com.startapp.sdk.ads.nativead.NativeAdPreferences;
import com.startapp.sdk.ads.nativead.StartAppNativeAd;
import com.startapp.sdk.adsbase.Ad;
import com.startapp.sdk.adsbase.adlisteners.AdEventListener;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import nemosofts.voxradio.R;
import nemosofts.voxradio.activity.PlayerService;
import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.item.ItemRadio;
import nemosofts.voxradio.utils.ApplicationUtil;

public class AdapterEpisodeList extends RecyclerView.Adapter {

    private final Context context;
    private List<ItemRadio> arrayList;
    private final List<ItemRadio> filteredArrayList;
    private final RecyclerItemClickListener listener;
    private NameFilter filter;
    private final int VIEW_PROG = -1;

    Boolean isAdLoaded = false;
    List<NativeAd> mNativeAdsAdmob = new ArrayList<>();

    public AdapterEpisodeList(Context context, List<ItemRadio> arrayList, RecyclerItemClickListener clickListener) {
        this.arrayList = arrayList;
        this.filteredArrayList = arrayList;
        this.context = context;
        this.listener = clickListener;
    }

    static class MyViewHolder extends RecyclerView.ViewHolder {

        private final RelativeLayout rl_podcasts_list;
        private final RoundedImageView iv_podcasts_list;
        private final TextView tv_podcasts_name, tv_podcasts_cat;
        private final ImageView iv_podcasts_play;
        private final RelativeLayout rl_native_ad;

        MyViewHolder(View view) {
            super(view);
            rl_podcasts_list = view.findViewById(R.id.rl_podcasts_list);
            iv_podcasts_list = view.findViewById(R.id.iv_podcasts_list);
            tv_podcasts_name = view.findViewById(R.id.tv_podcasts_list_name);
            tv_podcasts_cat = view.findViewById(R.id.tv_podcasts_list_cat);
            iv_podcasts_play = view.findViewById(R.id.iv_podcasts_play);

            rl_native_ad = view.findViewById(R.id.rl_native_ad);
        }
    }

    private static class ProgressViewHolder extends RecyclerView.ViewHolder {
        @SuppressLint("StaticFieldLeak")
        private static ProgressBar progressBar;
        private ProgressViewHolder(View v) {
            super(v);
            progressBar = v.findViewById(R.id.progressBar);
        }
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == VIEW_PROG) {
            View v = LayoutInflater.from(parent.getContext()).inflate(R.layout.row_progressbar, parent, false);
            return new ProgressViewHolder(v);
        } else {
            View itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_row_podcasts_vertical, parent, false);
            return new MyViewHolder(itemView);
        }
    }

    @Override
    public void onBindViewHolder(@NonNull final RecyclerView.ViewHolder holder, final int position) {
        if (holder instanceof MyViewHolder) {

            ((MyViewHolder) holder).tv_podcasts_name.setText(arrayList.get(position).getRadioTitle());
            ((MyViewHolder) holder).tv_podcasts_cat.setText(arrayList.get(position).getCategoryName());

            Picasso.get()
                    .load(arrayList.get(position).getImage())
                    .placeholder(R.drawable.material_design_default)
                    .into(((MyViewHolder) holder).iv_podcasts_list);

            if (PlayerService.getIsPlayling() && Callback.playPos <= holder.getAdapterPosition() && Callback.arrayList_play.get(Callback.playPos).getId().equals(arrayList.get(position).getId()) && Boolean.TRUE.equals(!Callback.isRadio)) {
                ((MyViewHolder) holder).iv_podcasts_play.setImageResource(R.drawable.ic_pause);
                ((MyViewHolder) holder).rl_podcasts_list.setBackgroundColor(ColorUtils.colorAccent50(context));
            } else {
                ((MyViewHolder) holder).iv_podcasts_play.setImageResource(R.drawable.ic_play);
                ((MyViewHolder) holder).rl_podcasts_list.setBackgroundColor(ContextCompat.getColor(context, android.R.color.transparent));
            }

            int step = 1;
            for (int i = 1; i < position + 1; i++) {
                step++;
                if (step > 7) {
                    step = 1;
                }
            }
            switch (step){
                case 2:
                    ((MyViewHolder) holder).iv_podcasts_play.setBackgroundTintList(ColorStateList.valueOf(ContextCompat.getColor(context, R.color.color_setting_2)));
                    break;
                case 3:
                    ((MyViewHolder) holder).iv_podcasts_play.setBackgroundTintList(ColorStateList.valueOf(ContextCompat.getColor(context, R.color.color_setting_3)));
                    break;
                case 4:
                    ((MyViewHolder) holder).iv_podcasts_play.setBackgroundTintList(ColorStateList.valueOf(ContextCompat.getColor(context, R.color.color_setting_4)));
                    break;
                case 5:
                    ((MyViewHolder) holder).iv_podcasts_play.setBackgroundTintList(ColorStateList.valueOf(ContextCompat.getColor(context, R.color.color_setting_5)));
                    break;
                case 6:
                    ((MyViewHolder) holder).iv_podcasts_play.setBackgroundTintList(ColorStateList.valueOf(ContextCompat.getColor(context, R.color.color_setting_6)));
                    break;
                case 7:
                    ((MyViewHolder) holder).iv_podcasts_play.setBackgroundTintList(ColorStateList.valueOf(ContextCompat.getColor(context, R.color.color_setting_7)));
                    break;
                default:
                    ((MyViewHolder) holder).iv_podcasts_play.setBackgroundTintList(ColorStateList.valueOf(ContextCompat.getColor(context, R.color.color_setting_1)));
                    break;
            }

            ((MyViewHolder) holder).rl_podcasts_list.setOnClickListener(view -> listener.onClick(getPosition(arrayList.get(holder.getAdapterPosition()).getId())));

            if (Boolean.TRUE.equals(Callback.isNativeAd && (position != arrayList.size() - 1) && (position + 1) % Callback.nativeAdShow == 0)) {
                try {
                    if (((MyViewHolder) holder).rl_native_ad.getChildCount() == 0) {
                        switch (Callback.adNetwork) {
                            case Callback.AD_TYPE_ADMOB:
                            case Callback.AD_TYPE_FACEBOOK:
                                if (Boolean.TRUE.equals(isAdLoaded) && (mNativeAdsAdmob.size() >= 5)) {

                                    int i = ApplicationUtil.getRandom(mNativeAdsAdmob.size() - 1);

                                    @SuppressLint("InflateParams") NativeAdView adView = (NativeAdView) ((Activity) context).getLayoutInflater().inflate(R.layout.layout_native_ad_admob, null);
                                    populateUnifiedNativeAdView(mNativeAdsAdmob.get(i), adView);
                                    ((MyViewHolder) holder).rl_native_ad.removeAllViews();
                                    ((MyViewHolder) holder).rl_native_ad.addView(adView);

                                    ((MyViewHolder) holder).rl_native_ad.setVisibility(View.VISIBLE);

                                }
                                break;
                            case Callback.AD_TYPE_STARTAPP:
                                StartAppNativeAd nativeAd = new StartAppNativeAd(context);

                                nativeAd.loadAd(new NativeAdPreferences()
                                        .setAdsNumber(1)
                                        .setAutoBitmapDownload(true)
                                        .setPrimaryImageSize(2), new AdEventListener() {
                                    @Override
                                    public void onReceiveAd(@NonNull Ad ad) {
                                        try {
                                            if (!nativeAd.getNativeAds().isEmpty()) {
                                                @SuppressLint("InflateParams") RelativeLayout nativeAdView = (RelativeLayout) ((Activity) context).getLayoutInflater().inflate(R.layout.layout_native_ad_startapp, null);

                                                ImageView icon = nativeAdView.findViewById(R.id.icon);
                                                TextView title = nativeAdView.findViewById(R.id.title);
                                                TextView description = nativeAdView.findViewById(R.id.description);
                                                Button button = nativeAdView.findViewById(R.id.button);

                                                Picasso.get()
                                                        .load(nativeAd.getNativeAds().get(0).getImageUrl())
                                                        .into(icon);
                                                title.setText(nativeAd.getNativeAds().get(0).getTitle());
                                                description.setText(nativeAd.getNativeAds().get(0).getDescription());
                                                button.setText(nativeAd.getNativeAds().get(0).isApp() ? "Install" : "Open");

                                                ((MyViewHolder) holder).rl_native_ad.removeAllViews();
                                                ((MyViewHolder) holder).rl_native_ad.addView(nativeAdView);
                                                ((MyViewHolder) holder).rl_native_ad.setVisibility(View.VISIBLE);
                                            }
                                        } catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                    }

                                    @Override
                                    public void onFailedToReceiveAd(Ad ad) {
                                    }
                                });
                                break;
                                case Callback.AD_TYPE_IRONSOURCE:
                                    IronSource.init(context, Callback.ironAdsId, IronSource.AD_UNIT.BANNER);
                                    IronSourceBannerLayout banner = IronSource.createBanner((Activity) context, ISBannerSize.BANNER);
                                    banner.setBannerListener(new com.ironsource.mediationsdk.sdk.BannerListener() {
                                        @Override
                                        public void onBannerAdLoaded() {
                                            ((MyViewHolder) holder).rl_native_ad.removeAllViews();
                                            ((MyViewHolder) holder).rl_native_ad.addView(banner);

                                            ((MyViewHolder) holder).rl_native_ad.setVisibility(View.VISIBLE);
                                        }

                                        @Override
                                        public void onBannerAdLoadFailed(IronSourceError error) {

                                        }

                                        @Override
                                        public void onBannerAdClicked() {
                                        }

                                        @Override
                                        public void onBannerAdScreenPresented() {
                                        }

                                        @Override
                                        public void onBannerAdScreenDismissed() {
                                        }

                                        @Override
                                        public void onBannerAdLeftApplication() {
                                        }
                                    });
                                    IronSource.loadBanner(banner);
                                break;
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public long getItemId(int id) {
        return id;
    }

    @Override
    public int getItemCount() {
        return arrayList.size();
    }

    @Override
    public int getItemViewType(int position) {
        if (arrayList.get(position) != null) {
            return position;
        } else {
            return VIEW_PROG;
        }
    }

    private int getPosition(String id) {
        int count = 0;
        for (int i = 0; i < filteredArrayList.size(); i++) {
            if (id.equals(filteredArrayList.get(i).getId())) {
                count = i;
                break;
            }
        }
        return count;
    }

    public Filter getFilter() {
        if (filter == null) {
            filter = new NameFilter();
        }
        return filter;
    }

    private class NameFilter extends Filter {

        @Override
        protected FilterResults performFiltering(CharSequence constraint) {

            constraint = constraint.toString().toLowerCase();
            FilterResults result = new FilterResults();
            if (constraint.toString().length() > 0) {
                ArrayList<ItemRadio> filteredItems = new ArrayList<>();

                for (int i = 0, l = filteredArrayList.size(); i < l; i++) {
                    String nameList = filteredArrayList.get(i).getRadioTitle();
                    if (nameList.toLowerCase().contains(constraint))
                        filteredItems.add(filteredArrayList.get(i));
                }
                result.count = filteredItems.size();
                result.values = filteredItems;
            } else {
                synchronized (this) {
                    result.values = filteredArrayList;
                    result.count = filteredArrayList.size();
                }
            }
            return result;
        }

        @SuppressLint("NotifyDataSetChanged")
        @SuppressWarnings("unchecked")
        @Override
        protected void publishResults(CharSequence constraint, FilterResults results) {
            arrayList = (ArrayList<ItemRadio>) results.values;
            notifyDataSetChanged();
        }
    }

    public void addAds(List<NativeAd> arrayListNativeAds) {
        isAdLoaded = true;
        mNativeAdsAdmob.addAll(arrayListNativeAds);
        for (int i = 0; i < arrayList.size(); i++) {
            if(arrayList.get(i) == null) {
                notifyItemChanged(i);
            }
        }
    }

    private void populateUnifiedNativeAdView(NativeAd nativeAd, NativeAdView adView) {
        MediaView mediaView = adView.findViewById(R.id.ad_media);
        adView.setMediaView(mediaView);

        // Set other ad assets.
        adView.setHeadlineView(adView.findViewById(R.id.ad_headline));
        adView.setBodyView(adView.findViewById(R.id.ad_body));
        adView.setCallToActionView(adView.findViewById(R.id.ad_call_to_action));
        adView.setIconView(adView.findViewById(R.id.ad_icon));
        adView.setPriceView(adView.findViewById(R.id.ad_price));
        adView.setStarRatingView(adView.findViewById(R.id.ad_stars));
        adView.setStoreView(adView.findViewById(R.id.ad_store));
        adView.setAdvertiserView(adView.findViewById(R.id.ad_advertiser));

        // The headline is guaranteed to be in every UnifiedNativeAd.
        ((TextView) Objects.requireNonNull(adView.getHeadlineView())).setText(nativeAd.getHeadline());

        // These assets aren't guaranteed to be in every UnifiedNativeAd, so it's important to
        // check before trying to display them.
        if (nativeAd.getBody() == null) {
            Objects.requireNonNull(adView.getBodyView()).setVisibility(View.INVISIBLE);
        } else {
            Objects.requireNonNull(adView.getBodyView()).setVisibility(View.VISIBLE);
            ((TextView) adView.getBodyView()).setText(nativeAd.getBody());
        }

        if (nativeAd.getCallToAction() == null) {
            Objects.requireNonNull(adView.getCallToActionView()).setVisibility(View.INVISIBLE);
        } else {
            Objects.requireNonNull(adView.getCallToActionView()).setVisibility(View.VISIBLE);
            ((Button) adView.getCallToActionView()).setText(nativeAd.getCallToAction());
        }

        if (nativeAd.getIcon() == null) {
            Objects.requireNonNull(adView.getIconView()).setVisibility(View.GONE);
        } else {
            ((ImageView) Objects.requireNonNull(adView.getIconView())).setImageDrawable(
                    nativeAd.getIcon().getDrawable());
            adView.getIconView().setVisibility(View.VISIBLE);
        }

        if (nativeAd.getPrice() == null) {
            Objects.requireNonNull(adView.getPriceView()).setVisibility(View.INVISIBLE);
        } else {
            Objects.requireNonNull(adView.getPriceView()).setVisibility(View.VISIBLE);
            ((TextView) adView.getPriceView()).setText(nativeAd.getPrice());
        }

        if (nativeAd.getStore() == null) {
            Objects.requireNonNull(adView.getStoreView()).setVisibility(View.INVISIBLE);
        } else {
            Objects.requireNonNull(adView.getStoreView()).setVisibility(View.VISIBLE);
            ((TextView) adView.getStoreView()).setText(nativeAd.getStore());
        }

        if (nativeAd.getStarRating() == null) {
            Objects.requireNonNull(adView.getStarRatingView()).setVisibility(View.INVISIBLE);
        } else {
            ((RatingBar) Objects.requireNonNull(adView.getStarRatingView()))
                    .setRating(nativeAd.getStarRating().floatValue());
            adView.getStarRatingView().setVisibility(View.VISIBLE);
        }

        if (nativeAd.getAdvertiser() == null) {
            Objects.requireNonNull(adView.getAdvertiserView()).setVisibility(View.INVISIBLE);
        } else {
            ((TextView) Objects.requireNonNull(adView.getAdvertiserView())).setText(nativeAd.getAdvertiser());
            adView.getAdvertiserView().setVisibility(View.VISIBLE);
        }

        // This method tells the Google Mobile Ads SDK that you have finished populating your
        // native ad view with this native ad. The SDK will populate the adView's MediaView
        // with the media content from this native ad.
        adView.setNativeAd(nativeAd);
    }

    public interface RecyclerItemClickListener{
        void onClick(int position);
    }

}